/* DO NOT EDIT THIS FILE */
/* This file is autogenerated by the text-database code generator */

#ifndef TOUCHGFX_COMPRESSEDUNMAPPEDFONTCACHE_HPP
#define TOUCHGFX_COMPRESSEDUNMAPPEDFONTCACHE_HPP

#include <touchgfx/hal/FlashDataReader.hpp>
#include <touchgfx/hal/Types.hpp>
#include <touchgfx/Font.hpp>

namespace touchgfx
{
class CompressedUnmappedFontCache
{
public:
    static void clearCache();
    static const GlyphNode* hasCachedGlyphNode(const GlyphNode* glyphNode);
    static const GlyphNode* hasCachedGlyphData(const GlyphNode* glyphNode, const uint8_t*& pixelData);
    static void unableToCache(const GlyphNode* glyphNode, int byteSize);
    static GlyphNode* cacheGlyphNode(const GlyphNode* glyph);
    static const uint8_t* cacheGlyphData(const GlyphNode* glyph, const uint8_t* compressedData, touchgfx::FlashDataReader* reader);
    static int usedMemory()
    {
        return pixelsTop - (uint8_t*)bitmapFontCache + glyphsAllocated * sizeof(BitmapFontCacheKey);
    }

    static int cacheClearCounter;
private:
    static uint8_t* decompressGlyph(uint8_t* pixelsTop, const GlyphNode* glyphNode, const uint8_t* compressedData, touchgfx::FlashDataReader* reader);

    struct BitmapFontCacheKey
    {
        const void* glyphNodeSrc;
        GlyphNode glyphNodeCopy;
        const uint8_t* pixels;
    };

    static const int cacheSizeBytes = 4096;
    static const int cacheWords = (cacheSizeBytes + 3) / 4;
    static uint32_t bitmapFontCache[cacheWords];
    static uint8_t* pixelsTop;
    static int glyphsAllocated;
};
} // namespace touchgfx

#endif // TOUCHGFX_COMPRESSEDUNMAPPEDFONTCACHE_HPP
